(function () {
  'use strict';
  let selectedCategory = '';

  const _Scene_Item_start = Scene_Item.prototype.start;
  Scene_Item.prototype.start = function () {
    _Scene_Item_start.call(this);
    if (selectedCategory) {
      this._categoryWindow.selectSymbol(selectedCategory);
      this._categoryWindow.deactivate();
      this._itemWindow.activate();
      this._itemWindow.selectLast();
      selectedCategory = '';
    }
  };

  const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    /**
     * プラグインコマンド: sceneItemWithCategory 開きたいカテゴリ
     * 開きたいカテゴリに指定できるもの:
     *  item
     *  weapon
     *  armor
     *  keyItem
     */
    if (command === 'sceneItemWithCategory') {
      selectedCategory = args[0];
      SceneManager.push(Scene_Item);
    }
  };
})();